/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI;

import emulator.EmulatorException;
import emulator.GUI.PersistentFrame;
import emulator.assembler.Assembler;
import emulator.hardware.CPU;
import emulator.hardware.bus.Bus;
import emulator.hardware.clock.Clock;
import emulator.hardware.io.Via6522;
import emulator.hardware.io.peripherals.iec.IecSim;
import emulator.hardware.io.porthistory.PortStateHistory;
import emulator.hardware.memory.MemoryBlockInterface;
import emulator.shell.DebugShell;
import emulator.shell.GUI.ConsoleCreateEvent;
import emulator.shell.GUI.ConsoleWriteEvent;
import emulator.shell.GUI.LogPanel;
import emulator.shell.GUI.WindowData;
import emulator.shell.GUI.menu.EditCopy;
import emulator.shell.GUI.menu.EditCut;
import emulator.shell.GUI.menu.EditPaste;
import emulator.shell.GUI.menu.FileExit;
import emulator.shell.GUI.menu.FileOpen;
import emulator.shell.GUI.menu.FileSave;
import emulator.shell.GUI.menu.HelpAbout;
import emulator.shell.GUI.menu.ShellCommand;
import emulator.util.events.EventAggregator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;

public class ConsoleFrame
extends Observable
implements ActionListener,
Observer,
LogPanel {
    private CPU cpu;
    private MemoryBlockInterface memory;
    private Bus bus;
    private Assembler assembler = new Assembler();
    private IecSim iec_sim;
    private Via6522 via1 = null;
    private Via6522 via2 = null;
    private JTextPane content = null;
    private JFrame frame = null;
    private JTextField input_field = null;
    private WindowData window_data = null;
    private JMenuItem menu_item_go;
    private JMenuItem menu_item_halt;
    private String appName;
    private PortStateHistory portStateHistory1;
    private PortStateHistory portStateHistory2;
    private Clock _clock;

    public ConsoleFrame(String appName) {
        this.appName = appName;
        this.window_data = new WindowData(appName, this);
    }

    @Override
    public void write(String text, SimpleAttributeSet attributes) {
        SwingUtilities.invokeLater(new ConsoleWriteEvent(this, text, attributes));
    }

    private JMenuBar createMenuBar() {
        JMenuBar menu_bar = new JMenuBar();
        this.createFileMenu(menu_bar);
        this.createEditMenu(menu_bar);
        this.createCommandMenu(menu_bar);
        this.createWindowMenu(menu_bar);
        this.createHelpMenu(menu_bar);
        return menu_bar;
    }

    private static JMenu createMenu(JMenuBar menu_bar, String caption, int shortcut) {
        JMenu menu = new JMenu(caption);
        menu.setMnemonic(shortcut);
        menu_bar.add(menu);
        return menu;
    }

    private static void addEditMenu(JMenu menu, String caption, String image_name, int key, ActionListener listener) {
        JMenuItem edit_menu = new JMenuItem(caption, new ImageIcon(image_name));
        edit_menu.setAccelerator(KeyStroke.getKeyStroke(key, 2));
        if (listener != null) {
            edit_menu.addActionListener(listener);
        }
        menu.add(edit_menu);
    }

    private static JMenuItem addMenuItem(JMenu menu, String caption, ActionListener listener) {
        JMenuItem menu_item = new JMenuItem(caption);
        menu_item.addActionListener(listener);
        menu.add(menu_item);
        return menu_item;
    }

    private static JMenuItem addMenuItem(JMenu menu, String caption, String icon, ActionListener listener) {
        JMenuItem menu_item = new JMenuItem(caption, new ImageIcon(icon));
        menu_item.addActionListener(listener);
        menu.add(menu_item);
        return menu_item;
    }

    private void createHelpMenu(JMenuBar menu_bar) {
        JMenu menu = ConsoleFrame.createMenu(menu_bar, "Help", 72);
        ConsoleFrame.addMenuItem(menu, "About...", new HelpAbout());
    }

    private void createWindowMenu(JMenuBar menu_bar) {
        JMenu menu = ConsoleFrame.createMenu(menu_bar, "Window", 87);
        this.window_data.addWindowMenu(menu, "Memory", 1);
        this.window_data.addWindowMenu(menu, "Configuration", 2);
        this.window_data.addWindowMenu(menu, "Debug", 3);
        this.window_data.addWindowMenu(menu, "IEC Log", 4);
        this.window_data.addWindowMenu(menu, "VIA 1", 5);
        this.window_data.addWindowMenu(menu, "VIA 2", 6);
        this.window_data.addWindowMenu(menu, "Settings", 7);
    }

    private void createCommandMenu(JMenuBar menu_bar) {
        JMenu menu = ConsoleFrame.createMenu(menu_bar, "CPU", 67);
        this.menu_item_go = ConsoleFrame.addMenuItem(menu, "Go", "images/run_icon.png", new ShellCommand("go"));
        this.menu_item_halt = ConsoleFrame.addMenuItem(menu, "Halt", "images/stop_icon.png", new ShellCommand("halt"));
        ConsoleFrame.addMenuItem(menu, "Reset", new ShellCommand("reset"));
        this.getCpu().addRunningStateObserver(this);
    }

    private void createEditMenu(JMenuBar menu_bar) {
        JMenu menu = ConsoleFrame.createMenu(menu_bar, "Edit", 69);
        ConsoleFrame.addEditMenu(menu, "Cut", "images/cut_icon.png", 88, new EditCut(this));
        ConsoleFrame.addEditMenu(menu, "Copy", "images/copy_icon.png", 67, new EditCopy(this));
        ConsoleFrame.addEditMenu(menu, "Paste", "images/paste_icon.png", 86, new EditPaste(this));
    }

    private void createFileMenu(JMenuBar menu_bar) {
        JMenu menu = ConsoleFrame.createMenu(menu_bar, "File", 70);
        ConsoleFrame.addMenuItem(menu, "Load...", "images/file_load.png", new FileOpen(this));
        ConsoleFrame.addMenuItem(menu, "Save...", "images/file_save.png", new FileSave(this));
        menu.addSeparator();
        ConsoleFrame.addMenuItem(menu, "Exit", new FileExit(this.window_data));
    }

    private void addComponentsToPane(Container pane) {
        if (!(pane.getLayout() instanceof BorderLayout)) {
            pane.add(new JLabel("Container doesn't use BorderLayout!"));
            return;
        }
        JLabel label = new JLabel("Debug Shell");
        pane.add((Component)label, "First");
        this.content = new JTextPane();
        this.content.setEditable(false);
        this.content.setPreferredSize(new Dimension(300, 300));
        pane.add((Component)new JScrollPane(this.content), "Center");
        this.input_field = new JTextField();
        this.input_field.addActionListener(this);
        pane.add((Component)this.input_field, "Last");
    }

    void createAndShowGUI() {
        this.frame = new PersistentFrame("Console", this.appName);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setJMenuBar(this.createMenuBar());
        this.addComponentsToPane(this.frame.getContentPane());
        ((PersistentFrame)this.frame).restorePosition();
        this.frame.setVisible(true);
        this.window_data.restoreWindowStates();
        try {
            this.getCpu().reset();
        }
        catch (EmulatorException e) {
            DebugShell.getInstance().getErr().println("EmulatorException: " + e.getMessage());
        }
    }

    public static ConsoleFrame createConsole(String appName, CPU cpu, MemoryBlockInterface memory, Bus bus) {
        ConsoleFrame console = new ConsoleFrame(appName);
        console.setCpu(cpu);
        console.setMemory(memory);
        console.setBus(bus);
        SwingUtilities.invokeLater(new ConsoleCreateEvent(console));
        return console;
    }

    @Override
    public JTextPane getContentFrame() {
        return this.content;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String input = this.input_field.getText();
        this.input_field.selectAll();
        this.setChanged();
        this.notifyObservers(input);
    }

    public void editCut() {
        this.input_field.cut();
    }

    public void editCopy() {
        this.input_field.copy();
    }

    public void editPaste() {
        this.input_field.paste();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    @Override
    public void update(Observable state, Object run_state) {
        this.updateRunMenu((Boolean)run_state);
    }

    private void updateRunMenu(boolean run_state) {
        this.menu_item_go.setEnabled(!run_state);
        this.menu_item_halt.setEnabled(run_state);
    }

    public CPU getCpu() {
        return this.cpu;
    }

    public void setCpu(CPU cpu) {
        this.cpu = cpu;
    }

    public MemoryBlockInterface getMemory() {
        return this.memory;
    }

    public void setMemory(MemoryBlockInterface memory) {
        this.memory = memory;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setAssembler(Assembler assembler) {
        this.assembler = assembler;
    }

    public Assembler getAssembler() {
        return this.assembler;
    }

    public void setIecSim(IecSim iec_sim) {
        this.iec_sim = iec_sim;
    }

    public IecSim getIecSim() {
        return this.iec_sim;
    }

    public void setVias(Via6522 via1, Via6522 via2) {
        if (via1 != null) {
            this.via1 = via1;
        }
        if (via2 != null) {
            this.via2 = via2;
        }
    }

    public Via6522 getVia1() {
        return this.via1;
    }

    public Via6522 getVia2() {
        return this.via2;
    }

    public void initPortStateHistory(EventAggregator eventAggregator) {
        this.portStateHistory1 = new PortStateHistory(this.via1, eventAggregator);
        this.portStateHistory2 = new PortStateHistory(this.via2, eventAggregator);
    }

    public PortStateHistory getPortStateHistory1() {
        return this.portStateHistory1;
    }

    public PortStateHistory getPortStateHistory2() {
        return this.portStateHistory2;
    }

    public void setClock(Clock clock) {
        this._clock = clock;
    }

    public Clock getClock() {
        return this._clock;
    }
}

